<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Preview\TrustedComms\BrandedChannel;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains preview products that are subject to change. Use them with caution. If you currently do not have developer preview access, please contact help@twilio.com.
 *
 * @property string $accountSid
 * @property string $businessSid
 * @property string $brandSid
 * @property string $brandedChannelSid
 * @property string $phoneNumberSid
 * @property string $phoneNumber
 * @property string $url
 */
class ChannelInstance extends InstanceResource {
    /**
     * Initialize the ChannelInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $brandedChannelSid Branded Channel Sid.
     */
    public function __construct(Version $version, array $payload, string $brandedChannelSid) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'businessSid' => Values::array_get($payload, 'business_sid'),
            'brandSid' => Values::array_get($payload, 'brand_sid'),
            'brandedChannelSid' => Values::array_get($payload, 'branded_channel_sid'),
            'phoneNumberSid' => Values::array_get($payload, 'phone_number_sid'),
            'phoneNumber' => Values::array_get($payload, 'phone_number'),
            'url' => Values::array_get($payload, 'url'),
        ];

        $this->solution = ['brandedChannelSid' => $brandedChannelSid, ];
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name) {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        return '[Twilio.Preview.TrustedComms.ChannelInstance]';
    }
}